/*
 * Decompiled with CFR 0.152.
 */
package xyz.etztech.minealert.listeners;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.ClickEvent;
import net.md_5.bungee.api.chat.ComponentBuilder;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.plugin.Plugin;
import xyz.etztech.minealert.Color;
import xyz.etztech.minealert.Lang;
import xyz.etztech.minealert.MineAlert;
import xyz.etztech.minealert.MuteType;

public class OreAlertListener
implements Listener {
    private final MineAlert plugin;
    private static final Set<Location> cache = Collections.synchronizedSet(new HashSet());
    private static final Map<UUID, List<BlockEvent>> map = new ConcurrentHashMap<UUID, List<BlockEvent>>();
    private static final Queue<BlockEvent> queue = new ConcurrentLinkedQueue<BlockEvent>();

    public OreAlertListener(MineAlert plugin) {
        this.plugin = plugin;
        this.plugin.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)plugin);
        this.plugin.getServer().getScheduler().runTaskAsynchronously((Plugin)this.plugin, this::task);
        this.plugin.getServer().getScheduler().runTaskTimerAsynchronously((Plugin)this.plugin, this::cleanup, 0L, (long)(1200 * this.plugin.getConfig().getInt("ore.cleanup", 5)));
    }

    @EventHandler
    public void onBlockBreak(BlockBreakEvent event) {
        if (MineAlert.hasIgnoreAlertPerm(event.getPlayer(), MuteType.OREALERT_MUTE).booleanValue()) {
            return;
        }
        if (cache.contains(event.getBlock().getLocation())) {
            return;
        }
        if (!this.isMaterialTracked(event.getBlock().getType())) {
            return;
        }
        queue.add(new BlockEvent(event.getPlayer(), event.getBlock().getType(), event.getBlock().getLocation(), true));
        int radius = this.plugin.getConfig().getInt("ore.radius", 3);
        for (int x = -radius; x < radius; ++x) {
            for (int y = -radius; y < radius; ++y) {
                for (int z = -radius; z < radius; ++z) {
                    Block block;
                    if (x == 0 && y == 0 && z == 0 || cache.contains((block = event.getBlock().getRelative(x, y, z)).getLocation()) || !this.isMaterialTracked(block.getType())) continue;
                    queue.add(new BlockEvent(event.getPlayer(), block.getType(), block.getLocation(), false));
                }
            }
        }
    }

    @EventHandler
    public void onBlockPlace(BlockPlaceEvent event) {
        this.plugin.getServer().getScheduler().runTaskAsynchronously((Plugin)this.plugin, () -> {
            Block eventBlock = event.getBlock();
            if (this.isMaterialTracked(eventBlock.getType())) {
                cache.add(eventBlock.getLocation());
            }
            if (eventBlock.getType() == Material.TNT || eventBlock.getType().toString().contains("_BED") && eventBlock.getWorld().getEnvironment() == World.Environment.NETHER) {
                for (int x = -4; x < 4; ++x) {
                    for (int y = -4; y < 4; ++y) {
                        for (int z = -4; z < 4; ++z) {
                            Block block = eventBlock.getRelative(x, y, z);
                            cache.add(block.getLocation());
                        }
                    }
                }
            }
        });
    }

    private boolean isMaterialTracked(Material material) {
        for (String s : this.plugin.getConfig().getConfigurationSection("ore.blocks").getKeys(false)) {
            if (!Lang.getMaterialKey(material).equals(s)) continue;
            return true;
        }
        return false;
    }

    private void task() {
        while (this.plugin.isEnabled()) {
            BlockEvent event = queue.poll();
            if (event == null || cache.contains(event.getLocation())) continue;
            cache.add(event.getLocation());
            if (!event.isParent().booleanValue()) continue;
            this.addStrike(event);
            this.check(event);
        }
    }

    private void addStrike(BlockEvent event) {
        List events = map.getOrDefault(event.getPlayer().getUniqueId(), new ArrayList());
        events.add(event);
        map.put(event.getPlayer().getUniqueId(), events);
    }

    private void check(BlockEvent event) {
        String blockKey = Lang.getMaterialKey(event.getMaterial());
        int start = this.plugin.getConfigIntFallback(5, String.format("ore.blocks.%s.start", blockKey), "ore.start");
        int each = this.plugin.getConfigIntFallback(1, String.format("ore.blocks.%s.each", blockKey), "ore.each");
        int ping = this.plugin.getConfigIntFallback(5, String.format("ore.blocks.%s.ping", blockKey), "ore.ping");
        int belowY = this.plugin.getConfigIntFallback(255, String.format("ore.blocks.%s.below_y", blockKey), "ore.below_y");
        int aboveY = this.plugin.getConfigIntFallback(0, String.format("ore.blocks.%s.above_y", blockKey), "ore.above_y");
        this.purge(((List)map.getOrDefault(event.getPlayer().getUniqueId(), new ArrayList())).iterator());
        int yLevel = event.location.getBlockY();
        if (yLevel > belowY || yLevel < aboveY) {
            return;
        }
        if (MuteType.GRIEFALERT_MUTE.hasMuteStatus(event.getPlayer(), this.plugin)) {
            return;
        }
        int strikes = 0;
        for (BlockEvent e : (List)map.getOrDefault(event.getPlayer().getUniqueId(), new ArrayList())) {
            if (!e.isParent().booleanValue() || !e.getMaterial().name().equals(event.getMaterial().name())) continue;
            ++strikes;
        }
        double alert = (double)strikes / (double)start;
        if (alert == 1.0) {
            this.sendAlert(event, strikes, true);
        } else if (alert > 1.0) {
            if (strikes % ping == 0) {
                this.sendAlert(event, strikes, true);
            } else if (strikes % each == 0) {
                this.sendAlert(event, strikes, false);
            }
        }
    }

    private void cleanup() {
        Iterator<UUID> it = map.keySet().iterator();
        while (it.hasNext()) {
            UUID playerUUID = it.next();
            this.purge(map.get(playerUUID).iterator());
            if (!map.get(playerUUID).isEmpty()) continue;
            it.remove();
        }
    }

    private void purge(Iterator<BlockEvent> events) {
        Date now = Calendar.getInstance().getTime();
        while (events.hasNext()) {
            BlockEvent e = events.next();
            int purge = 60000 * this.plugin.getConfigIntFallback(30, String.format("ore.blocks.%s.purge", Lang.getMaterialKey(e.getMaterial())), "ore.purge");
            if (!new Date(e.getTime().getTime() + (long)purge).before(now)) continue;
            cache.remove(e.getLocation());
            events.remove();
        }
    }

    private void sendAlert(BlockEvent event, int strikes, boolean ping) {
        String message = Lang.ORE_ALERT.getMessage(event.getPlayer().getName(), strikes, Lang.getMaterialName(event.getMaterial()));
        Color color = new Color(this.plugin.getConfigStringFallback("#AAAAAA", String.format("ore.blocks.%s.color", Lang.getMaterialKey(event.getMaterial())), "ore.color"));
        String usernameURL = this.plugin.getConfigStringFallback("", String.format("ore.blocks.%s.url", Lang.getMaterialKey(event.getMaterial())), "ore.url", "url");
        usernameURL = MineAlert.formatAlertURL(usernameURL, event.getPlayer(), event.getLocation());
        ComponentBuilder builder = new ComponentBuilder().append(message).color(color.getChatColor());
        if (!"".equals(usernameURL)) {
            builder.event(new ClickEvent(ClickEvent.Action.OPEN_URL, usernameURL));
        }
        BaseComponent[] component = builder.create();
        for (Player player : Bukkit.getOnlinePlayers()) {
            if (!player.hasPermission("minealert.alert")) continue;
            player.spigot().sendMessage(component);
        }
        String webhook = this.plugin.getConfigStringFallback("", String.format("ore.blocks.%s.webhook", Lang.getMaterialKey(event.getMaterial())), "ore.webhook", "webhook");
        if (!"".equals(webhook)) {
            this.plugin.sendWebhook(webhook, color, event.getPlayer(), event.getLocation(), message, usernameURL);
        }
    }

    public static Set<Location> getCache() {
        return cache;
    }

    public static Map<UUID, List<BlockEvent>> getMap() {
        return map;
    }

    public static Queue<BlockEvent> getQueue() {
        return queue;
    }

    private static class BlockEvent {
        private final Player player;
        private final Material material;
        private final Location location;
        private final Boolean parent;
        private final Date time;

        BlockEvent(Player player, Material material, Location location, Boolean parent) {
            this.player = player;
            this.material = material;
            this.location = location;
            this.parent = parent;
            this.time = Calendar.getInstance().getTime();
        }

        public Player getPlayer() {
            return this.player;
        }

        public Material getMaterial() {
            return this.material;
        }

        public Location getLocation() {
            return this.location;
        }

        public Boolean isParent() {
            return this.parent;
        }

        public Date getTime() {
            return this.time;
        }
    }
}

