/*
 * Decompiled with CFR 0.152.
 */
package xyz.etztech.minealert.listeners;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.ClickEvent;
import net.md_5.bungee.api.chat.ComponentBuilder;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockIgniteEvent;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.event.player.PlayerBucketEmptyEvent;
import org.bukkit.plugin.Plugin;
import xyz.etztech.minealert.Color;
import xyz.etztech.minealert.Lang;
import xyz.etztech.minealert.MineAlert;
import xyz.etztech.minealert.MuteType;

public class GriefAlertListener
implements Listener {
    private final MineAlert plugin;
    private final Map<String, List<Date>> map = new HashMap<String, List<Date>>();

    public GriefAlertListener(MineAlert plugin) {
        this.plugin = plugin;
        this.plugin.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)this.plugin);
        this.plugin.getServer().getScheduler().runTaskTimerAsynchronously((Plugin)this.plugin, this::purge, 0L, 1200L);
    }

    public void purge() {
        Date now = Calendar.getInstance().getTime();
        int purge = 60000 * this.plugin.getConfig().getInt("grief.reset", 10);
        Iterator<List<Date>> it = this.map.values().iterator();
        while (it.hasNext()) {
            List<Date> dates = it.next();
            dates.removeIf(date -> new Date(date.getTime() + (long)purge).before(now));
            if (dates.size() != 0) continue;
            it.remove();
        }
    }

    public void addAlert(Player player, Location eventLocation, Lang lang) {
        if (MineAlert.hasIgnoreAlertPerm(player, MuteType.GRIEFALERT_MUTE).booleanValue()) {
            return;
        }
        String playerName = player.getName();
        String alert = lang.getMessage(playerName);
        this.purge();
        int aboveY = this.plugin.getConfigIntFallback(0, "grief.above_y");
        int belowY = this.plugin.getConfigIntFallback(255, "grief.below_y");
        int eventYLevel = eventLocation.getBlockY();
        if (eventYLevel > belowY || eventYLevel < aboveY) {
            return;
        }
        List dates = this.map.getOrDefault(alert, new ArrayList());
        dates.add(new Date());
        this.map.put(alert, dates);
        if (MuteType.GRIEFALERT_MUTE.hasMuteStatus(player, this.plugin)) {
            return;
        }
        Color color = new Color(this.plugin.getConfigStringFallback("#FFA500", "grief.color"));
        String usernameURL = this.plugin.getConfigStringFallback("", "grief.url", "url");
        usernameURL = MineAlert.formatAlertURL(usernameURL, player, eventLocation);
        int threshold = this.plugin.getConfig().getInt("grief.threshold", 5);
        if (dates.size() <= threshold) {
            StringBuilder extra = new StringBuilder();
            if (dates.size() == threshold) {
                extra.append(" Suppressing more alerts for a while");
                String webhook = this.plugin.getConfigStringFallback("", "grief.webhook", "webhook");
                if (!"".equals(webhook)) {
                    extra.append(" and pinging Discord");
                    this.plugin.sendWebhook(webhook, color, player, eventLocation, alert, usernameURL);
                }
                extra.append("...");
            }
            ComponentBuilder builder = new ComponentBuilder().append(alert + extra.toString()).color(color.getChatColor());
            if (!"".equals(usernameURL)) {
                builder.event(new ClickEvent(ClickEvent.Action.OPEN_URL, usernameURL));
            }
            this.sendAlert(builder.create());
        }
    }

    public void sendAlert(BaseComponent[] message) {
        for (Player player : Bukkit.getOnlinePlayers()) {
            if (!player.hasPermission("minealert.alert")) continue;
            player.spigot().sendMessage(message);
        }
    }

    @EventHandler
    public void onBlockIgnite(BlockIgniteEvent event) {
        if (event.getPlayer() != null && this.plugin.getConfig().getStringList("grief.enabled").contains("ignition") && (event.getCause() == BlockIgniteEvent.IgniteCause.FLINT_AND_STEEL || event.getCause() == BlockIgniteEvent.IgniteCause.FIREBALL)) {
            this.addAlert(event.getPlayer(), event.getBlock().getLocation(), Lang.IGNITE_ALERT);
        }
    }

    @EventHandler
    public void onBlockPlace(BlockPlaceEvent event) {
        if (this.plugin.getConfig().getStringList("grief.enabled").contains("tnt") && event.getBlockPlaced().getType() == Material.TNT) {
            this.addAlert(event.getPlayer(), event.getBlock().getLocation(), Lang.TNT_ALERT);
        }
    }

    @EventHandler
    public void onBucketEmpty(PlayerBucketEmptyEvent event) {
        if (this.plugin.getConfig().getStringList("grief.enabled").contains("lava") && event.getBucket() == Material.LAVA_BUCKET) {
            this.addAlert(event.getPlayer(), event.getBlock().getLocation(), Lang.LAVA_ALERT);
        }
    }
}

