/*
 * Decompiled with CFR 0.152.
 */
package xyz.etztech.minealert.commands;

import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.ComponentBuilder;
import org.bukkit.Bukkit;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.plugin.Plugin;
import xyz.etztech.Javacord;
import xyz.etztech.Webhook;
import xyz.etztech.embed.Author;
import xyz.etztech.embed.Embed;
import xyz.etztech.minealert.Color;
import xyz.etztech.minealert.Lang;
import xyz.etztech.minealert.MineAlert;
import xyz.etztech.minealert.listeners.OreAlertListener;

public class MainCommand
implements CommandExecutor {
    MineAlert plugin;

    public MainCommand(MineAlert plugin) {
        this.plugin = plugin;
        this.plugin.getCommand("minealert").setExecutor((CommandExecutor)this);
    }

    public boolean onCommand(CommandSender commandSender, Command command, String s, String[] args) {
        if (!commandSender.hasPermission("minealert.admin")) {
            Lang.NO_PERMISSION.sms(commandSender, new Object[0]);
            return true;
        }
        if (args.length == 0) {
            this.help(commandSender);
        } else {
            switch (args[0]) {
                case "help": {
                    this.help(commandSender);
                    break;
                }
                case "reload": {
                    this.reload(commandSender);
                    break;
                }
                case "webhook": {
                    this.webhook(commandSender);
                    break;
                }
                case "status": {
                    this.status(commandSender);
                    break;
                }
                default: {
                    Lang.UNKNOWN_COMMAND.sms(commandSender, new Object[0]);
                }
            }
        }
        return true;
    }

    private void help(CommandSender commandSender) {
        String version = Bukkit.getPluginManager().getPlugin("MineAlert").getDescription().getVersion();
        BaseComponent[] message = new ComponentBuilder().append(String.format("===== MineAlert v%s =====", version)).color(Color.PRIMARY.getChatColor()).append("\n/minealert help - Show this message").color(Color.INFO.getChatColor()).append("\n/minealert reload - Reload the config").color(Color.INFO.getChatColor()).append("\n/minealert status - Check the cache, map, and queue").color(Color.INFO.getChatColor()).append("\n/minealert webhook - Test the global webhook").color(Color.INFO.getChatColor()).create();
        commandSender.spigot().sendMessage(message);
    }

    private void reload(CommandSender commandSender) {
        this.plugin.reloadConfig();
        Lang.PLUGIN_RELOADED.sms(commandSender, new Object[0]);
    }

    private void status(CommandSender commandSender) {
        BaseComponent[] message = new ComponentBuilder().append("===== MineAlert Status =====").color(Color.PRIMARY.getChatColor()).append("\nCache: ").color(Color.PRIMARY.getChatColor()).append(String.format("%d", OreAlertListener.getCache().size())).color(Color.INFO.getChatColor()).append("\nMap: ").color(Color.PRIMARY.getChatColor()).append(String.format("%d", OreAlertListener.getMap().size())).color(Color.INFO.getChatColor()).append("\nQueue: ").color(Color.PRIMARY.getChatColor()).append(String.format("%d", OreAlertListener.getQueue().size())).color(Color.INFO.getChatColor()).create();
        commandSender.spigot().sendMessage(message);
    }

    private void webhook(CommandSender commandSender) {
        String webhook = this.plugin.getConfig().getString("webhook", "");
        if ("".equals(webhook)) {
            Color.ERROR.sms(commandSender, "Global webhook cannot be blank to test.");
            return;
        }
        this.plugin.getServer().getScheduler().runTaskAsynchronously((Plugin)this.plugin, () -> {
            try {
                Embed embed = new Embed().color(Color.PRIMARY.getInt()).description("Test Message").author(new Author("Console", "", "https://minotar.net/helm/Notch/100.png", ""));
                Javacord.sendWebhook(webhook, new Webhook("", embed));
                Color.INFO.sms(commandSender, "Webhook sent!");
            }
            catch (Exception e) {
                Lang.WEBHOOK_FAILED.sms(commandSender, new Object[0]);
            }
        });
    }
}

