/*
 * Decompiled with CFR 0.152.
 */
package xyz.etztech.minealert.commands;

import java.util.LinkedList;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.ComponentBuilder;
import org.bukkit.Bukkit;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import xyz.etztech.core.command.TickDuration;
import xyz.etztech.minealert.Color;
import xyz.etztech.minealert.Lang;
import xyz.etztech.minealert.MineAlert;
import xyz.etztech.minealert.MuteType;

public class AlertMute
implements CommandExecutor {
    MineAlert plugin;

    public AlertMute(MineAlert plugin) {
        this.plugin = plugin;
        this.plugin.getCommand("alertmute").setExecutor((CommandExecutor)this);
    }

    public boolean onCommand(CommandSender commandSender, Command command, String commandPassed, String[] args) {
        if (!commandSender.hasPermission("minealert.alert_mute")) {
            Lang.NO_PERMISSION.sms(commandSender, new Object[0]);
            return true;
        }
        if (args.length == 0) {
            BaseComponent[] message = new ComponentBuilder().color(Color.INFO.getChatColor()).append("/").append(commandPassed).append(" <player> <duration> [ore|grief]").create();
            commandSender.spigot().sendMessage(message);
        } else {
            TickDuration duration;
            final Player player = commandSender.getServer().getPlayer(args[0]);
            if (player == null) {
                Lang.PLAYER_NOT_FOUND.sms(commandSender, new Object[0]);
                return true;
            }
            try {
                duration = TickDuration.parse(args[1]);
            }
            catch (Exception e) {
                Lang.DURATION_PARSE_ERROR.sms(commandSender, new Object[0]);
                return true;
            }
            final LinkedList<MuteType> mutes = new LinkedList<MuteType>();
            if (args.length == 3) {
                switch (args[2].toLowerCase()) {
                    case "ore": {
                        mutes.add(MuteType.OREALERT_MUTE);
                        break;
                    }
                    case "grief": {
                        mutes.add(MuteType.GRIEFALERT_MUTE);
                        break;
                    }
                    default: {
                        Lang.UNKNOWN_COMMAND.sms(commandSender, new Object[0]);
                        return true;
                    }
                }
            } else {
                mutes.add(MuteType.GRIEFALERT_MUTE);
                mutes.add(MuteType.OREALERT_MUTE);
            }
            for (MuteType mute : mutes) {
                mute.setMuteStatus(player, this.plugin);
            }
            Bukkit.getScheduler().runTaskLater((Plugin)this.plugin, new Runnable(){

                @Override
                public void run() {
                    for (MuteType mute : mutes) {
                        mute.removeMuteStatus(player, AlertMute.this.plugin);
                    }
                }
            }, duration.toTicks());
            Lang.ALERT_MUTE.sms(commandSender, player.getName());
        }
        return true;
    }
}

