/*
 * Decompiled with CFR 0.152.
 */
package xyz.etztech.minealert;

import java.time.OffsetDateTime;
import java.util.logging.Logger;
import org.bukkit.Location;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import xyz.etztech.Javacord;
import xyz.etztech.Webhook;
import xyz.etztech.embed.Author;
import xyz.etztech.embed.Embed;
import xyz.etztech.embed.Field;
import xyz.etztech.minealert.Color;
import xyz.etztech.minealert.Lang;
import xyz.etztech.minealert.MuteType;
import xyz.etztech.minealert.commands.AlertMute;
import xyz.etztech.minealert.commands.MainCommand;
import xyz.etztech.minealert.listeners.GriefAlertListener;
import xyz.etztech.minealert.listeners.OreAlertListener;

public class MineAlert
extends JavaPlugin {
    private static MineAlert instance;
    private final Logger log = Logger.getLogger("Minecraft");

    public void onEnable() {
        instance = this;
        this.saveDefaultConfig();
        this.reloadConfig();
        if (this.isEnabled()) {
            new MainCommand(this);
            new GriefAlertListener(this);
            new OreAlertListener(this);
            new AlertMute(this);
        }
    }

    public void log(String message) {
        this.log.info("[MineAlert]: " + message);
    }

    public static MineAlert getInstance() {
        return instance;
    }

    public String getConfigStringFallback(String def, String ... path) {
        String fallback = "";
        for (String p : path) {
            fallback = this.getConfig().getString(p, fallback);
            if ("".equals(fallback)) continue;
            return fallback;
        }
        return def;
    }

    public int getConfigIntFallback(int def, String ... path) {
        int fallback = 0;
        for (String p : path) {
            fallback = this.getConfig().getInt(p, fallback);
            if (fallback == 0) continue;
            return fallback;
        }
        return def;
    }

    public static Boolean hasIgnoreAlertPerm(Player player, MuteType muteType) {
        return player.hasPermission("minealert.ignore") || player.hasPermission(muteType.getMetadataValue());
    }

    public static String formatAlertURL(String baseURL, Player player, Location location) {
        return baseURL.replaceAll("\\{username}", player.getName()).replaceAll("\\{x}", String.valueOf(location.getBlockX())).replaceAll("\\{y}", String.valueOf(location.getBlockY())).replaceAll("\\{z}", String.valueOf(location.getBlockZ())).replaceAll("\\{world_name}", location.getWorld().getName());
    }

    public static String formattedLocation(Location location) {
        return String.format("%d %d %d", location.getBlockX(), location.getBlockY(), location.getBlockZ());
    }

    public static Embed buildAlertEmbed(Color color, Player player, Location location, String message, String baseURL) {
        String usernameURL = MineAlert.formatAlertURL(baseURL, player, location);
        return new Embed().color(color.getInt()).description(Javacord.escapeFormat(message)).timestamp(OffsetDateTime.now()).author(new Author(player.getName(), !"".equals(usernameURL) ? usernameURL : "", String.format("https://minotar.net/helm/%s/100.png", player.getName()), "")).addField(new Field("Location", String.format("`%s`", MineAlert.formattedLocation(location)))).addField(new Field("World", String.format("`%s`", location.getWorld().getName())));
    }

    public void sendWebhook(String webhookURL, Color color, Player player, Location location, String message, String baseURL) {
        this.getServer().getScheduler().runTaskAsynchronously((Plugin)this, () -> {
            Embed embed = MineAlert.buildAlertEmbed(color, player, location, message, baseURL);
            try {
                Javacord.sendWebhook(webhookURL, new Webhook("@here", embed));
            }
            catch (Exception e) {
                this.log(Lang.WEBHOOK_FAILED.getMessage(new Object[0]));
            }
        });
    }
}

