/*
 * Decompiled with CFR 0.152.
 */
package xyz.etztech.minealert;

import org.apache.commons.lang.WordUtils;
import org.bukkit.Material;
import org.bukkit.command.CommandSender;
import xyz.etztech.minealert.Color;

public enum Lang {
    NO_PERMISSION("You don't have permission to do that.", Color.ERROR),
    UNKNOWN_COMMAND("This command wasn't recognized.", Color.ERROR),
    PLUGIN_RELOADED("MineAlert reloaded.", Color.INFO),
    WEBHOOK_FAILED("Could not send webhook.", Color.ERROR),
    PLAYER_NOT_FOUND("Could not find the player specified.", Color.ERROR),
    DURATION_PARSE_ERROR("Error parsing time format.", Color.ERROR),
    ALERT_MUTE("%s's alerts have been muted.", Color.PRIMARY),
    ORE_ALERT("%s has found %d %s veins.", Color.DEFAULT),
    IGNITE_ALERT("%s started a fire.", Color.DEFAULT),
    TNT_ALERT("%s placed TnT.", Color.DEFAULT),
    LAVA_ALERT("%s poured lava.", Color.DEFAULT);

    private final String message;
    private final Color color;

    private Lang(String message, Color color) {
        this.message = message;
        this.color = color;
    }

    public String getMessage(Object ... args) {
        return String.format(this.message, args);
    }

    public Color getColor() {
        return this.color;
    }

    public void sms(CommandSender sender, Object ... args) {
        this.color.sms(sender, String.format(this.message, args));
    }

    public static String getMaterialName(Material material) {
        String name = Lang.getMaterialKey(material);
        name = name.replaceAll("_", " ");
        name = WordUtils.capitalize(name);
        return name;
    }

    public static String getMaterialKey(Material material) {
        return material.name().toLowerCase();
    }
}

