/*
 * Decompiled with CFR 0.152.
 */
package xyz.etztech.minealert;

import net.md_5.bungee.api.ChatColor;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.TextComponent;
import org.bukkit.command.CommandSender;
import org.bukkit.command.ConsoleCommandSender;
import xyz.etztech.minealert.MineAlert;

public class Color {
    public static Color DEFAULT = new Color("#AAAAAA");
    public static Color ERROR = new Color("#F14668");
    public static Color INFO = new Color("#3298DC");
    public static Color PRIMARY = new Color("#3273DC");
    private final String hex;
    private final ChatColor chatColor;

    public Color(String hex) {
        this.hex = hex;
        this.chatColor = ChatColor.of((String)hex);
    }

    public String getHex() {
        return this.hex;
    }

    public int getInt() {
        return Color.hexToInt(this.hex);
    }

    public ChatColor getChatColor() {
        return this.chatColor;
    }

    public void sms(CommandSender commandSender, String message) {
        if (commandSender instanceof ConsoleCommandSender) {
            MineAlert.getInstance().log(message);
            return;
        }
        TextComponent text = new TextComponent(message);
        text.setColor(this.chatColor);
        commandSender.spigot().sendMessage((BaseComponent)text);
    }

    public static int hexToInt(String hex) {
        if (hex.startsWith("#")) {
            hex = hex.substring(1);
        }
        if (hex.length() != 6) {
            return 0;
        }
        return Integer.parseInt(hex, 16);
    }
}

