/*
 * Decompiled with CFR 0.152.
 */
package xyz.etztech.embed;

import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import xyz.etztech.Javacord;
import xyz.etztech.embed.Author;
import xyz.etztech.embed.Field;
import xyz.etztech.embed.Footer;
import xyz.etztech.embed.Image;
import xyz.etztech.embed.Thumbnail;

public class Embed {
    private String content = "";
    private String title = "";
    private String description = "";
    private String url = "";
    private int color = 0;
    private OffsetDateTime timestamp = null;
    private Footer footer = null;
    private Thumbnail thumbnail = null;
    private Image image = null;
    private Author author = null;
    private List<Field> fields = new ArrayList<Field>();

    public Embed content(String content) {
        this.content = content;
        return this;
    }

    public Embed title(String title) {
        this.title = title;
        return this;
    }

    public Embed description(String description) {
        this.description = description;
        return this;
    }

    public Embed url(String url) {
        this.url = url;
        return this;
    }

    public Embed color(int color) {
        this.color = color;
        return this;
    }

    public Embed timestamp(OffsetDateTime timestamp) {
        this.timestamp = timestamp;
        return this;
    }

    public Embed footer(Footer footer) {
        this.footer = footer;
        return this;
    }

    public Embed thumbnail(Thumbnail thumbnail) {
        this.thumbnail = thumbnail;
        return this;
    }

    public Embed image(Image image) {
        this.image = image;
        return this;
    }

    public Embed author(Author author) {
        this.author = author;
        return this;
    }

    public Embed fields(List<Field> fields) {
        this.fields = fields;
        return this;
    }

    public Embed addField(Field field) {
        this.fields.add(field);
        return this;
    }

    public String toJSON() {
        StringBuilder builder = new StringBuilder("{");
        ArrayList<String> json = new ArrayList<String>();
        if (!"".equals(this.title)) {
            json.add(String.format("\"title\":\"%s\"", Javacord.escapeQuote(this.title)));
        }
        if (!"".equals(this.description)) {
            json.add(String.format("\"description\":\"%s\"", Javacord.escapeQuote(this.description)));
        }
        if (!"".equals(this.url)) {
            json.add(String.format("\"url\":\"%s\"", Javacord.escapeQuote(this.url)));
        }
        if (this.color != 0) {
            json.add(String.format("\"color\":\"%d\"", this.color));
        }
        if (this.timestamp != null) {
            json.add(String.format("\"timestamp\":\"%s\"", this.timestamp.format(DateTimeFormatter.ISO_INSTANT)));
        }
        if (this.footer != null) {
            json.add(String.format("\"footer\":%s", this.footer.toJSON()));
        }
        if (this.thumbnail != null) {
            json.add(String.format("\"thumbnail\":%s", this.thumbnail.toJSON()));
        }
        if (this.image != null) {
            json.add(String.format("\"image\":%s", this.image.toJSON()));
        }
        if (this.author != null) {
            json.add(String.format("\"author\":%s", this.author.toJSON()));
        }
        if (this.fields.size() > 0) {
            json.add(String.format("\"fields\":[%s]", this.fields.stream().map(Field::toJSON).collect(Collectors.joining(","))));
        }
        builder.append(String.join((CharSequence)",", json));
        return builder.append("}").toString();
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("{");
        ArrayList<String> json = new ArrayList<String>();
        if (!"".equals(this.content)) {
            json.add(String.format("\"content\":\"%s\"", Javacord.escapeQuote(this.content)));
        }
        if (!"{}".equals(this.toJSON())) {
            json.add(String.format("\"embed\":%s", this.toJSON()));
        }
        builder.append(String.join((CharSequence)",", json));
        return builder.append("}").toString();
    }
}

