/*
 * Decompiled with CFR 0.152.
 */
package xyz.etztech.core.web;

import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.util.logging.Logger;
import net.md_5.bungee.api.chat.ComponentBuilder;
import net.md_5.bungee.api.chat.TextComponent;
import org.bukkit.ChatColor;

public class Response {
    private JsonObject json;
    private Boolean status;
    private String message;
    private static final Logger log = Logger.getLogger("Minecraft");

    public Response(JsonArray httpResponse) {
        this.json = httpResponse.get(0).getAsJsonObject();
        this.setStatus(this.json.get("status").getAsBoolean());
        this.setMessage(this.json.get("message").getAsString());
    }

    public Response(JsonObject httpResponse) {
        this.json = httpResponse;
        this.setStatus(httpResponse.get("status").getAsBoolean());
        this.setMessage(httpResponse.get("message").getAsString());
    }

    public Response(String rawReponse) {
        JsonParser parser = new JsonParser();
        try {
            this.json = (JsonObject)parser.parse(rawReponse);
            this.setStatus(this.json.get("status").getAsBoolean());
            this.setMessage(this.json.get("message").getAsString());
        }
        catch (Exception ex) {
            log.warning("Could not parse JSON result");
        }
    }

    public JsonObject getJson() {
        return this.json;
    }

    public void setJson(JsonObject json) {
        this.json = json;
    }

    public Boolean getStatus() {
        return this.status;
    }

    public void setStatus(Boolean status) {
        this.status = status;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    @Deprecated
    public String getMCMessage() {
        if (this.status.booleanValue()) {
            return ChatColor.GREEN + this.message;
        }
        return ChatColor.RED + this.message;
    }

    public TextComponent getMCJSON() {
        ComponentBuilder builder = new ComponentBuilder(this.message);
        if (this.status.booleanValue()) {
            builder.color(net.md_5.bungee.api.ChatColor.GREEN);
        } else {
            builder.color(net.md_5.bungee.api.ChatColor.RED);
        }
        return new TextComponent(builder.create());
    }
}

