/*
 * Decompiled with CFR 0.152.
 */
package xyz.etztech.core.web;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;

public class MultipartUtility {
    private final String boundary;
    private static final String LINE_FEED = "\r\n";
    private final HttpURLConnection httpConn;
    private final String charset;
    private final OutputStream outputStream;
    private final PrintWriter writer;

    public MultipartUtility(String requestURL, String charset) throws IOException {
        this.charset = charset;
        this.boundary = "===" + System.currentTimeMillis() + "===";
        URL url = new URL(requestURL);
        this.httpConn = (HttpURLConnection)url.openConnection();
        this.httpConn.setUseCaches(false);
        this.httpConn.setDoOutput(true);
        this.httpConn.setDoInput(true);
        this.httpConn.setRequestProperty("Content-Type", "multipart/form-data; boundary=" + this.boundary);
        this.httpConn.setRequestProperty("User-Agent", "PluginAPI Agent");
        this.outputStream = this.httpConn.getOutputStream();
        this.writer = new PrintWriter((Writer)new OutputStreamWriter(this.outputStream, charset), true);
    }

    public void addFormField(String name, String value) {
        this.writer.append("--").append(this.boundary).append(LINE_FEED);
        this.writer.append("Content-Disposition: form-data; name=\"").append(name).append("\"").append(LINE_FEED);
        this.writer.append("Content-Type: text/plain; charset=").append(this.charset).append(LINE_FEED);
        this.writer.append(LINE_FEED);
        this.writer.append(value).append(LINE_FEED);
        this.writer.flush();
    }

    public void addFilePart(String fieldName, File uploadFile) throws IOException {
        String fileName = uploadFile.getName();
        this.writer.append("--").append(this.boundary).append(LINE_FEED);
        this.writer.append("Content-Disposition: form-data; name=\"").append(fieldName).append("\"; filename=\"").append(fileName).append("\"").append(LINE_FEED);
        this.writer.append("Content-Type: ").append(URLConnection.guessContentTypeFromName(fileName)).append(LINE_FEED);
        this.writer.append("Content-Transfer-Encoding: binary").append(LINE_FEED);
        this.writer.append(LINE_FEED);
        this.writer.flush();
        FileInputStream inputStream = new FileInputStream(uploadFile);
        byte[] buffer = new byte[4096];
        int bytesRead = -1;
        while ((bytesRead = inputStream.read(buffer)) != -1) {
            this.outputStream.write(buffer, 0, bytesRead);
        }
        this.outputStream.flush();
        inputStream.close();
        this.writer.append(LINE_FEED);
        this.writer.flush();
    }

    public void addHeaderField(String name, String value) {
        this.writer.append(name).append(": ").append(value).append(LINE_FEED);
        this.writer.flush();
    }

    public String finish() throws IOException {
        BufferedReader reader;
        StringBuilder response = new StringBuilder();
        this.writer.append("--").append(this.boundary).append("--").append(LINE_FEED);
        this.writer.close();
        int status = this.httpConn.getResponseCode();
        if (status < 300) {
            reader = new BufferedReader(new InputStreamReader(this.httpConn.getInputStream()));
            String line = null;
            while ((line = reader.readLine()) != null) {
                response.append(line);
            }
        } else {
            throw new IOException("Server returned non-OK status: " + status);
        }
        reader.close();
        this.httpConn.disconnect();
        return response.toString();
    }
}

