/*
 * Decompiled with CFR 0.152.
 */
package xyz.etztech.core.web;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.util.Map;
import java.util.StringJoiner;
import java.util.logging.Logger;
import org.bukkit.Bukkit;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitScheduler;
import xyz.etztech.core.web.ICallback;
import xyz.etztech.core.web.MultipartUtility;

public class Http {
    private static BukkitScheduler schedule = null;
    private static final Logger logger = Logger.getLogger("Minecraft");

    public static void asyncGet(Plugin plugin, String url, Map<String, String> data) {
        schedule.runTaskAsynchronously(plugin, () -> {
            try {
                Http.HTTP(url, Method.GET, data);
            }
            catch (Exception ex) {
                logger.warning("GET request failed. (" + url + ")");
            }
        });
    }

    public static void asyncGetCallback(Plugin plugin, String url, Map<String, String> data, ICallback callback) {
        schedule.runTaskAsynchronously(plugin, () -> {
            try {
                String result = Http.HTTP(url, Method.GET, data);
                callback.invoke(result);
            }
            catch (Exception ex) {
                logger.warning("GET request failed. (" + url + ")");
            }
        });
    }

    public static void asyncPost(Plugin plugin, String url, Map<String, String> data) {
        schedule.runTaskAsynchronously(plugin, () -> {
            try {
                Http.HTTP(url, Method.POST, data);
            }
            catch (Exception ex) {
                logger.warning("POST request failed. (" + url + ")");
            }
        });
    }

    public static void asyncPostCallback(Plugin plugin, String url, Map<String, String> data, ICallback callback) {
        schedule.runTaskAsynchronously(plugin, () -> {
            try {
                String result = Http.HTTP(url, Method.POST, data);
                callback.invoke(result);
            }
            catch (Exception ex) {
                logger.warning("POST request failed. (" + url + ")");
            }
        });
    }

    public static String HTTP(String endpoint, Method method, Map<String, String> data) throws Exception {
        String inputLine;
        if (method == Method.POST) {
            MultipartUtility request = new MultipartUtility(endpoint, "utf-8");
            for (String key : data.keySet()) {
                request.addFormField(key, data.get(key));
            }
            return request.finish();
        }
        StringJoiner sj = new StringJoiner("&");
        for (Map.Entry<String, String> entry : data.entrySet()) {
            sj.add(URLEncoder.encode(entry.getKey(), "UTF-8") + "=" + URLEncoder.encode(entry.getValue(), "UTF-8"));
        }
        endpoint = endpoint + "?" + sj.toString();
        URL url = new URL(endpoint);
        HttpURLConnection http = (HttpURLConnection)url.openConnection();
        StringBuilder result = new StringBuilder();
        BufferedReader in = new BufferedReader(new InputStreamReader(http.getInputStream()));
        while ((inputLine = in.readLine()) != null) {
            result.append(inputLine);
        }
        http.disconnect();
        return result.toString();
    }

    static {
        try {
            schedule = Bukkit.getScheduler();
        }
        catch (Exception ex) {
            logger.warning("Could not get scheduler. Is this running outside Minecraft?");
        }
    }

    public static enum Method {
        GET,
        POST;

    }
}

