/*
 * Decompiled with CFR 0.152.
 */
package xyz.etztech.core.maven;

import java.io.File;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.util.logging.Logger;
import org.bukkit.plugin.java.JavaPlugin;
import xyz.etztech.core.maven.MavenLibrary;

public final class MavenLoader {
    static final String MAVEN_REPOSITORY = "http://repo.maven.apache.org/maven2/";
    private static final Method ADD_URL;
    private static JavaPlugin plugin;
    private static Logger log;

    public static void loadAll(Class<?> clazz) {
        plugin = JavaPlugin.getProvidingPlugin(clazz);
        log = plugin.getLogger();
        MavenLibrary[] libs = (MavenLibrary[])clazz.getDeclaredAnnotationsByType(MavenLibrary.class);
        if (libs == null) {
            return;
        }
        for (MavenLibrary lib : libs) {
            MavenLoader.load(lib.group(), lib.artifact(), lib.version(), lib.repository());
        }
    }

    private static void load(String group, String artifact, String version, String repository) {
        log.info(String.format("Loading dependency %s:%s:%s", group, artifact, version));
        String name = artifact + "-" + version;
        File jarFile = new File(MavenLoader.getLibraryFolder(), name + ".jar");
        if (!jarFile.exists()) {
            try {
                log.info(String.format("Dependency '%s' was not found. Attempting to download from %s...", name, repository));
                URL url = MavenLoader.getURL(group, artifact, version, repository);
                try (InputStream in = url.openStream();){
                    Files.copy(in, jarFile.toPath(), new CopyOption[0]);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            log.info("Dependency '" + name + "' downloaded successfully.");
        }
        if (!jarFile.exists()) {
            throw new RuntimeException("Dependency does not exist: " + name);
        }
        URLClassLoader classLoader = (URLClassLoader)plugin.getClass().getClassLoader();
        try {
            ADD_URL.invoke((Object)classLoader, jarFile.toURI().toURL());
        }
        catch (Exception e) {
            throw new RuntimeException("Error loading dependency: " + jarFile.toString(), e);
        }
        log.info("Loaded dependency '" + name + "'.");
    }

    private static File getLibraryFolder() {
        File pluginsDir = plugin.getDataFolder().getParentFile();
        File libraryDir = new File(pluginsDir, "PluginAPI/lib");
        libraryDir.mkdirs();
        return libraryDir;
    }

    private static URL getURL(String group, String artifact, String version, String repository) throws Exception {
        String repo = repository;
        if (!repo.endsWith("/")) {
            repo = repo + "/";
        }
        String path = String.format("%s/%s/%s/%s-%s.jar", group.replace(".", "/"), artifact, version, artifact, version);
        return new URL(repo + path);
    }

    static {
        try {
            ADD_URL = URLClassLoader.class.getDeclaredMethod("addURL", URL.class);
            ADD_URL.setAccessible(true);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
    }
}

