/*
 * Decompiled with CFR 0.152.
 */
package xyz.etztech.core.command;

import java.time.Duration;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class TickDuration {
    private Duration duration;

    public TickDuration(Duration duration) {
        this.duration = duration;
    }

    public long toTicks() {
        return this.duration.getSeconds() * 20L;
    }

    public Duration getDuration() {
        return this.duration;
    }

    public static TickDuration parse(String time) throws Exception {
        String secondString;
        String minuteString;
        String timePattern = "(?:(?<hours>\\d+)h)?(?:(?<minutes>\\d+)m)?(?:(?<seconds>\\d+)s)?";
        Pattern pattern = Pattern.compile(timePattern);
        Matcher match = pattern.matcher(time);
        Duration duration = Duration.ZERO;
        if (!match.matches()) {
            throw new Exception("Time format does not match");
        }
        String hourString = match.group("hours");
        if (hourString != null) {
            int hours = Integer.parseInt(hourString);
            duration = duration.plusHours(hours);
        }
        if ((minuteString = match.group("minutes")) != null) {
            int minutes = Integer.parseInt(minuteString);
            duration = duration.plusMinutes(minutes);
        }
        if ((secondString = match.group("seconds")) != null) {
            int seconds = Integer.parseInt(secondString);
            duration = duration.plusSeconds(seconds);
        }
        return new TickDuration(duration);
    }
}

